require "util"
require "rincewind/craputil"
require "strings"
local Screen = require "widgets/screen"
local Menu = require "widgets/menu"
local Widget = require "widgets/widget"
local TextEdit = require "widgets/textedit"

local VALID_CHARS = [[ abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.,:;[]\@!#$%&()'*+-/=?^_{|}~"]]

--------------------------------------------------------------------------------------------------------------------------------------------------

local SignScreen = Class(Screen, function(self,p)
	Screen._ctor(self, "SignScreen")

	self.active = true
	SetPause(true,"pause")

	self.text = ""
	if p and p.components and p.components.signable then
		self.text = p.components.signable.text
		self.signable = p.components.signable
	end
	
	self.root = self:AddChild(Widget("ROOT"))
	self.root:SetVAnchor(ANCHOR_MIDDLE)
	self.root:SetHAnchor(ANCHOR_MIDDLE)
	self.root:SetPosition(0,0,0)
	self.root:SetScaleMode(SCALEMODE_PROPORTIONAL)
    
	local shield = self.root:AddChild( Image( "images/globalpanels.xml", "panel.tex" ) )
	shield:SetPosition( 0,0,0 )
	shield:SetSize( 500, 300 )

	local label_height = 50
	local signtext_offset = 30
	local fontsize = 30
	local edit_width = 350
	local edit_bg_padding = 60

    self.signtext_bg = self.root:AddChild( Image() )
	self.signtext_bg:SetTexture( "images/ui.xml", "textbox_long.tex" )
	self.signtext_bg:SetPosition( 0, signtext_offset, 0 )
	self.signtext_bg:ScaleToSize( edit_width + edit_bg_padding, label_height )

	self.signtext = self.root:AddChild( TextEdit( BODYTEXTFONT, fontsize, self.text or "") )
	self.signtext:SetPosition( 0, signtext_offset, 0 )
	self.signtext:SetRegionSize( edit_width, label_height )
	self.signtext:SetHAlign(ANCHOR_LEFT)
	self.signtext:SetFocusedImage( self.signtext_bg, UI_ATLAS, "textbox_long_over.tex", "textbox_long.tex" )
	self.signtext:SetTextLengthLimit(60)
	self.signtext:SetCharacterFilter(VALID_CHARS)

--	self.signtext:SetEditing(true)

	self.menu = self.root:AddChild(Menu(nil, 200, true))
	self.menu:SetPosition(-50, -70 ,0)
	self.menu:SetScale(0.6)
	self.menu:AddItem("Write", function() self:OnOK(true) end)
	self.menu:AddItem("Cancel", function() self:OnOK() end)

	self.default_focus = self.signtext
end)

local function EnabledOptionsIndex( enabled )
	if enabled then	return 2 else return 1 end
end

function SignScreen:OnOK(f)
	if f then
		self.text = self.signtext:GetLineEditString()
		if string.len(self.text) > 0 and self.signable then
			self.signable:SetText(self.text)
			self.signable.signed = true
		end
	end
	self.active = false
	SetPause(false)
	TheFrontEnd:PopScreen()
end

function SignScreen:OnControl(control, down)
	if SignScreen._base.OnControl(self,control, down) then return true end

	if (control == CONTROL_PAUSE or control == CONTROL_CANCEL) and not down then	
		self:OnOK()
		return true
		--[[
	elseif control == CONTROL_ACCEPT and not down then
		self:OnOK(true)
		return true
		]]
	end
end

function SignScreen:OnUpdate(dt)
	if self.active then
		SetPause(true)
	end
end

return SignScreen